﻿//////////////////////////////////////////////
// Compositor.h
//
//////////////////////////////////////////////

/// Defines / macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class CompositorNode ;
	class Texture ;
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Resources/Resource.h"

// Export
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/String.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Classe -----------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT Compositor : public nkExport::Exportable
	{		
		public :
		
			// Destructor
			virtual ~Compositor () ;

			// Getters
			unsigned int getNodeCount () const ;
			CompositorNode* getNode (unsigned int index) const ;
			System* getSystem () const ;
			nkMemory::StringView getName () const ;
			bool getHidden () const ;

			// Setters
			void setName (nkMemory::StringView value) ;
			void setHidden (bool value) ;

			// Node management
			virtual CompositorNode* addNode () ;
			virtual void deleteNode (unsigned int index) ;
			virtual void changeNodeOrder (unsigned int fromIndex, unsigned int toIndex) ;
			virtual void clearNodes () ;

			// Rendering
			virtual void renderChain () ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

			// Operators
			Compositor& operator= (const Compositor&) = delete ;

		public :

			// Statics
			static nkMemory::UniquePtr<Compositor> create (System* system = nullptr) ;

		protected :

			// Functions
			// Constructors
			Compositor (System* system) noexcept ;
			Compositor (const Compositor&) = delete ;

		protected :
		
			// Attributes
			// Nodes making our rendering chain
			nkMemory::BufferCast<nkMemory::UniquePtr<CompositorNode>> _renderChain ;
			
			// State
			System* _system ;
			nkMemory::String _name ;

			// Flags
			bool _hidden ;

		private :

			// Allocations
			virtual nkMemory::UniquePtr<CompositorNode> _allocateCompositorNode () = 0 ;
	} ;
}